'''
Created on Aug 1, 2011

@author: Shareef Dabdoub

This module will calculate of the convex hull of a set of 
points in 3D space.

Translated from the java implementation of the 3D convex hull algorithm 
from the book Computational Geometry in C (Joseph O'Rourke).
http://www.cs.sunysb.edu/~algorith/implement/orourke/implement.shtml
'''
import numpy as np

def convhull(pts):
    """
    Calculates the convex hull of a set of 3D points.
    
    :@type pts: numpy.ndarray
    :@param pts: The list of 3D points
    """

def Collinear(a, b, c):
    """
    Collinear checks to see if the three points given are collinear,
    by checking to see if each element of the cross product is zero.
    
    :@type a: Vec3f
    :@type b: Vec3f
    :@type c: Vec3f
    
    :@rtype: bool
    :@return: True if points a/b/c are collinear, False otherwise.
    """
    return 
    ( c.z - a.z ) * ( b.y - a.y ) -
    ( b.z - a.z ) * ( c.y - a.y ) == 0
    and ( b.z - a.z ) * ( c.x - a.x ) -
    ( b.x - a.x ) * ( c.z - a.z ) == 0
    and ( b.x - a.x ) * ( c.y - a.y ) -
    ( b.y - a.y ) * ( c.x - a.x ) == 0